#!/usr/bin/perl

# Define Variables

$host = 'www.affund.org';
chomp $host;
$basedir = "../../iboard";
$baseurl = "http://$host/iboard";
$cgi_url = "http://$host/cgi-bin/iboard/iadmin.cgi";

$mesgdir = "messages";
$datafile = "data.txt";
$mesgfile = "iboard.html";
$passwd_file = "passwd.txt";
#$passwd_file = "secure/passwd.txt";

$ext = "htm";

$title = "iBoard from The iWorks L.L.C.";
$use_time = 1;		# 1 = YES; 0 = NO

# Done
###########################################################################

if ($ENV{'QUERY_STRING'} ne '') {
   $command = "$ENV{'QUERY_STRING'}";
}
else {
   &parse_form;
}

print "Content-type: text/html\n\n";

###########################################################################
# Remove                                                                  #
#       This option is useful to see how the threads appear in the        #
#   iboard.html document.  It can give you a better idea of whether or  #
#   not you want to remove the whole thread or just part of it.           #
###########################################################################

if ($command eq 'remove') {
   print "<html><head><title>AFF Message Board Administration</title>\n";
   print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style> \n";
   print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script>\n";
   print "</head>\n";
   print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center class=sec><i>Remove Messages From AFF Message Board</i></td></tr>\n";
   print "<tr><td align=left><br>Select below to remove those postings you wish to remove.\n";
   print "Checking the Input Box on the left will remove the whole thread\n";
   print "while checking the Input Box on the right to remove just that posting.<p>\n";
   print "These messages have been left unsorted, so that you can see the order in\n";
   print "which they appear in the $mesgpage page.  This will give you an idea of\n";
   print "what the threads look like and is often more helpful than the sorted method.<br><br></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "<tr><td align=center><a href=\"$cgi_url\?remove\" class=sec><b>REMOVE</b></a> | <a href=\"$cgi_url\?remove_by_date\" class=sec><b>REMOVE BY DATE</b></a> | <a href=\"$cgi_url\?remove_by_author\" class=sec><b>REMOVE BY AUTHOR</b></a> | <a href=\"$cgi_url\?remove_by_num\" class=sec><b>REMOVE BY MESSAGE NUMBER</b></a> | <a href=\"$cgi_url\" class=sec><b>ADMIN HOME</b></a> | <a href=\"javascript:boardWin('http://www.affund.org/cgi-bin/iboard/gp.cgi?p=10')\" class=sec><b>VIEW BOARD</b></a></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "</table>\n";
   print "<form method=POST action=\"$cgi_url\">\n";
   print "<input type=hidden name=\"action\" value=\"remove\">\n";
   print "<table border=0 cellpadding=2 cellspacing=1 bgcolor=0099ff width=625>\n";
   print "<tr><td bgcolor=003366 align=center><b>Post #</td><td bgcolor=003366 align=center><b>Thread</td><td bgcolor=003366 align=center><b>Single</td><td bgcolor=003366 align=center><b>Subject</td><td bgcolor=003366 align=center><b>Author</td><td bgcolor=003366 align=center><b>Date</td></tr>\n";

   open(MSGS,"../../iboard/$mesgfile");
   @lines = <MSGS>;
   close(MSGS);
###print "lines: $baseurl\/$mesgdir\/\1\.$ext\n";

   foreach $line (@lines) {
      if ($line =~ /<!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">(.*)<\/a><\/b> - (.*)\s+<i>(.*)<\/i>/ ) {
         push(@ENTRIES,$1);
         $SUBJECT{$1} = $2;
         $AUTHOR{$1} = $3;
         $DATE{$1} = $4;
      }
      elsif ($line =~ /<!--PARENT--><br><!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">(.*)<\/a><\/b> - (.*)\s+<i>(.*)<\/i>/ ) {
         push(@ENTRIES,$1);
         $SUBJECT{$1} = $2;
         $AUTHOR{$1} = $3;
         $DATE{$1} = $4;
      }
   }

   @SORTED_ENTRIES = (sort { $a <=> $b } @ENTRIES);
   $max = pop(@SORTED_ENTRIES);
   $min = shift(@SORTED_ENTRIES);

   print "<input type=hidden name=\"min\" value=\"$min\">\n";
   print "<input type=hidden name=\"max\" value=\"$max\">\n";
   print "<input type=hidden name=\"type\" value=\"remove\">\n";

   foreach (@ENTRIES) {
      print "<tr>\n";
      print "<td bgcolor=003366 align=center><b>$_</b> </td><td bgcolor=003366 align=center><input type=radio name=\"$_\" value=\"all\"> </td><td bgcolor=003366 align=center><input type=radio name=\"$_\" value=\"single\"> </td><td bgcolor=003366><a href=\"$baseurl/$mesgdir/$_\.$ext\">$SUBJECT{$_} </a></td><td bgcolor=003366>$AUTHOR{$_} </td><td bgcolor=003366 align=center>$DATE{$_}<br></td>\n";

      print "</tr>\n";
   }
   print "</table><br><table width=500 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center><b>Username: <input type=text name=\"username\"></td><td align=center><b>Password: <input type=password name=\"password\"></td></tr></table>\n";
   print "<center><p>\n";
   print "<input type=submit value=\"Remove Messages\"> <input type=reset>\n";
   print "</form>\n";
   print "</body></html>\n";
}

###########################################################################
# Remove By Number                                                        #
#       This method is useful to see in what order the messages were      #
#   added to the iboard.html document.                                  #
###########################################################################

elsif ($command eq 'remove_by_num') {
   print "<html><head><title>AFF Message Board Administration</title>\n";
   print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style> \n";
   print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script>\n";
   print "</head>\n";
   print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center class=sec><i>Remove Messages By Message Number</i></td></tr>\n";
   print "<tr><td align=left><br>Select below to remove those postings you wish to remove.\n";
   print "Checking the Input Box on the left will remove the whole thread\n";
   print "while checking the Input Box on the right to remove just that posting.<br><br></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "<tr><td align=center><a href=\"$cgi_url\?remove\" class=sec><b>REMOVE</b></a> | <a href=\"$cgi_url\?remove_by_date\" class=sec><b>REMOVE BY DATE</b></a> | <a href=\"$cgi_url\?remove_by_author\" class=sec><b>REMOVE BY AUTHOR</b></a> | <a href=\"$cgi_url\?remove_by_num\" class=sec><b>REMOVE BY MESSAGE NUMBER</b></a> | <a href=\"$cgi_url\" class=sec><b>ADMIN HOME</b></a> | <a href=\"javascript:boardWin('http://www.affund.org/cgi-bin/iboard/gp.cgi?p=10')\" class=sec><b>VIEW BOARD</b></a></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "</table>\n";
   print "<form method=POST action=\"$cgi_url\">\n";
   print "<input type=hidden name=\"action\" value=\"remove\">\n";
   print "<table border=0 cellpadding=2 cellspacing=1 bgcolor=0099ff width=625>\n";
   print "<tr><td bgcolor=003366 align=center><b>Post #</td><td bgcolor=003366 align=center><b>Thread</td><td bgcolor=003366 align=center><b>Single</td><td bgcolor=003366 align=center><b>Subject</td><td bgcolor=003366 align=center><b>Author</td><td bgcolor=003366 align=center><b>Date</td></tr>\n";

   open(MSGS,"../../iboard/$mesgfile");
   @lines = <MSGS>;
   close(MSGS);

   foreach $line (@lines) {
      if ($line =~ /<!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">(.*)<\/a><\/b> - (.*)\s+<i>(.*)<\/i>/ ) {
#      if ($line =~ /<!--top: (.*)--><li><a href="$mesgdir\/\1\.$ext">(.*)<\/a> - <b>(.*)<\/b>\s+<i>(.*)<\/i>/) {
         push(@ENTRIES,$1);
         $SUBJECT{$1} = $2;
         $AUTHOR{$1} = $3;
         $DATE{$1} = $4;
      }
      elsif ($line =~ /<!--PARENT--><br><!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">(.*)<\/a><\/b> - (.*)\s+<i>(.*)<\/i>/ ) {
#      if ($line =~ /<!--top: (.*)--><li><a href="$mesgdir\/\1\.$ext">(.*)<\/a> - <b>(.*)<\/b>\s+<i>(.*)<\/i>/) {
         push(@ENTRIES,$1);
         $SUBJECT{$1} = $2;
         $AUTHOR{$1} = $3;
         $DATE{$1} = $4;
      }
   }

   @SORTED_ENTRIES = (sort { $a <=> $b } @ENTRIES);
   $max = pop(@SORTED_ENTRIES);
   $min = shift(@SORTED_ENTRIES);
   push(@SORTED_ENTRIES,$max);
   unshift(@SORTED_ENTRIES,$min);

   print "<input type=hidden name=\"min\" value=\"$min\">\n";
   print "<input type=hidden name=\"max\" value=\"$max\">\n";
   print "<input type=hidden name=\"type\" value=\"remove\">\n";

   foreach (@SORTED_ENTRIES) {
      print "<tr>\n";
      print "<td bgcolor=003366 align=center><b>$_</b> </td><td bgcolor=003366 align=center><input type=radio name=\"$_\" value=\"all\"> </td><td bgcolor=003366 align=center><input type=radio name=\"$_\" value=\"single\"> </td><td bgcolor=003366><a href=\"$baseurl/$mesgdir/$_\.$ext\">$SUBJECT{$_} </a></td><td bgcolor=003366>$AUTHOR{$_} </td><td bgcolor=003366 align=center>$DATE{$_}<br></td>\n";

      print "</tr>\n";
   }
   print "</table><br><table width=500 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center><b>Username: <input type=text name=\"username\"></td><td align=center><b>Password: <input type=password name=\"password\"></td></tr></table>\n";
   print "<center><p>\n";
   print "<input type=submit value=\"Remove Messages\"> <input type=reset>\n";
   print "</form>\n";
   print "</body></html>\n";
}

###########################################################################
# Remove By Date                                                          #
#       Using this method allows you to delete all messages posted before #
#   a certain date.                                                       #
###########################################################################

elsif ($command eq 'remove_by_date') {
   print "<html><head><title>AFF Message Board Administration</title>\n";
   print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style> \n";
   print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script>\n";
   print "</head>\n";
   print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center class=sec><i>Remove Messages By Message Date</i></td></tr>\n";
   print "<tr><td align=left><br>Select below to remove those postings you wish to remove.\n";
   print "Checking the input box beside a date will remove all postings \n";
   print "that occurred on that date.<br><br></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "<tr><td align=center><a href=\"$cgi_url\?remove\" class=sec><b>REMOVE</b></a> | <a href=\"$cgi_url\?remove_by_date\" class=sec><b>REMOVE BY DATE</b></a> | <a href=\"$cgi_url\?remove_by_author\" class=sec><b>REMOVE BY AUTHOR</b></a> | <a href=\"$cgi_url\?remove_by_num\" class=sec><b>REMOVE BY MESSAGE NUMBER</b></a> | <a href=\"$cgi_url\" class=sec><b>ADMIN HOME</b></a> | <a href=\"javascript:boardWin('http://www.affund.org/cgi-bin/iboard/gp.cgi?p=10')\" class=sec><b>VIEW BOARD</b></a></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "</table>\n";
   print "<form method=POST action=\"$cgi_url\">\n";
   print "<input type=hidden name=\"action\" value=\"remove_by_date_or_author\">\n";
   print "<input type=hidden name=\"type\" value=\"remove_by_date\">\n";
   print "<center>\n";
   print "<table border=0 cellpadding=2 cellspacing=1 bgcolor=0099ff width=625>\n";
   print "<tr><td bgcolor=003366 align=center><b>X</td><td bgcolor=003366 align=center><b>Date </td><td bgcolor=003366 align=center><b># of Messages </td><td bgcolor=003366 align=center><b>Message Numbers</td></tr>\n";

   open(MSGS,"../../iboard/$mesgfile");
   @lines = <MSGS>;
   close(MSGS);

   foreach $line (@lines) {
#      if ($line =~ /<!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">(.*)<\/a><\/b> - (.*)\s+<i>(.*)<\/i>/ ) {
#      if ($line =~ /<!--top: (.*)--><li><a href="$mesgdir\/\1\.$ext">.*<\/a> - <b>.*<\/b>\s+<i>(.*)<\/i>/) {
      if ($line =~ /<!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">.*<\/a><\/b> - .*\s+<i>(.*)<\/i>/ ) {
         $date = $2;
         if ($use_time == 1) {
            ($time,$day) = split(/\s+/,$date);
         }
         else {
            $day = $date;
         }
         $DATE{$1} = $day;
      }
      elsif ($line =~ /<!--PARENT--><br><!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">.*<\/a><\/b> - .*\s+<i>(.*)<\/i>/ ) {
         $date = $2;
         if ($use_time == 1) {
            ($time,$day) = split(/\s+/,$date);
         }
         else {
            $day = $date;
         }
         $DATE{$1} = $day;
      }
   }

   undef(@used_values);
   foreach $value (sort (values %DATE)) {
      $match = '0';
      $value_number = 0;
      foreach $used_value (@used_values) {
         if ($value eq $used_value) {
            $match = '1';
            last;
         }
      }
      if ($match == '0') {
         undef(@values); undef(@short_values);
         foreach $key (keys %DATE) {
            if ($value eq $DATE{$key}) {
               $key_url = "<a href=\"$baseurl/$mesgdir/$key\.$ext\">$key</a>,";
               push(@values,$key_url);
	       push(@short_values,$key);
               $value_number++;
            }
         }
         $form_value = $value;
         $form_value =~ s/\//_/g;
         print "<tr>\n";
         print "<td bgcolor=003366 align=center><input type=checkbox name=\"$form_value\" value=\"@short_values\"> </td><td bgcolor=003366 align=center>$value </td><td bgcolor=003366 align=center>$value_number </td><td bgcolor=003366 align=left>@values<br></td>\n";
         print "</tr>\n";
         push(@used_values,$value);
         push(@used_form_values,$form_value);
      }
   }
   print "</table><br><table width=500 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center><b>Username: <input type=text name=\"username\"></td><td align=center><b>Password: <input type=password name=\"password\"></td></tr></table>\n";
   print "<center><p>\n";
   print "<input type=submit value=\"Remove Messages\"> <input type=reset>\n";
   print "</form>\n";
   print "</body></html>\n";
}

###########################################################################
# Remove By Author                                                        #
#       This option makes a list of all known authors and then groups     #
#    together there postings and allows you to remove them all at once.   #
###########################################################################

elsif ($command eq 'remove_by_author') {
   print "<html><head><title>AFF Message Board Administration</title>\n";
   print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style> \n";
   print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script>\n";
   print "</head>\n";
   print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center class=sec><i>Remove Messages By Message Author</i></td></tr>\n";
   print "<tr><td align=left><br>Checking the checkbox beside the name of an author will remove \n";
   print "all postings which that author has created.<br><br></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "<tr><td align=center><a href=\"$cgi_url\?remove\" class=sec><b>REMOVE</b></a> | <a href=\"$cgi_url\?remove_by_date\" class=sec><b>REMOVE BY DATE</b></a> | <a href=\"$cgi_url\?remove_by_author\" class=sec><b>REMOVE BY AUTHOR</b></a> | <a href=\"$cgi_url\?remove_by_num\" class=sec><b>REMOVE BY MESSAGE NUMBER</b></a> | <a href=\"$cgi_url\" class=sec><b>ADMIN HOME</b></a> | <a href=\"javascript:boardWin('http://www.affund.org/cgi-bin/iboard/gp.cgi?p=10')\" class=sec><b>VIEW BOARD</b></a></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "</table>\n";
   print "<form method=POST action=\"$cgi_url\">\n";
   print "<input type=hidden name=\"action\" value=\"remove_by_date_or_author\">\n";
   print "<input type=hidden name=\"type\" value=\"remove_by_author\">\n";
   print "<center>\n";
   print "<table border=0 cellpadding=2 cellspacing=1 bgcolor=0099ff width=625>\n";
   print "<tr>\n";
   print "<td bgcolor=003366 align=center><b>X</td><td bgcolor=003366 align=center><b>Author</td><td bgcolor=003366 align=center><b># of Messages</td><td bgcolor=003366 align=center><b>Message #'s</td></tr>\n";

   open(MSGS,"../../iboard/$mesgfile");
   @lines = <MSGS>;
   close(MSGS);

   foreach $line (@lines) {
      if ($line =~ /<!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">.*<\/a><\/b> - (.*)\s+<i>.*<\/i>/ ) {
#      if ($line =~ /<!--top: (.*)--><li><a href="$mesgdir\/\1\.$ext">.*<\/a> - <b>(.*)<\/b>\s+<i>.*<\/i>/) {
         $AUTHOR{$1} = $2;
      }
      elsif ($line =~ /<!--PARENT--><br><!--top: (.*)--><li><b><a href="$baseurl\/$mesgdir\/\1\.$ext">.*<\/a><\/b> - (.*)\s+<i>.*<\/i>/ ) {
#      if ($line =~ /<!--top: (.*)--><li><a href="$mesgdir\/\1\.$ext">.*<\/a> - <b>(.*)<\/b>\s+<i>.*<\/i>/) {
         $AUTHOR{$1} = $2;
      }
   }

   undef(@used_values);
   foreach $value (sort (values %AUTHOR)) {
      $match = '0';
      $value_number = 0;
      foreach $used_value (@used_values) {
         if ($value eq $used_value) {
            $match = '1';
            last;
         }
      }
      if ($match == '0') {
         undef(@values); undef(@short_values);
         foreach $key (keys %AUTHOR) {
            if ($value eq $AUTHOR{$key}) {
               $key_url = "<a href=\"$baseurl/$mesgdir/$key\.$ext\">$key</a>";
               push(@values,$key_url);
               push(@short_values,$key);
               $value_number++;
            }
         }
         $form_value = $value;
         $form_value =~ s/ /_/g;
         print "<tr>\n";
         print "<td bgcolor=003366 align=center><input type=checkbox name=\"$form_value\" value=\"@short_values\"> </td><td bgcolor=003366 align=center>$value</td><td bgcolor=003366 align=center>$value_number</td><td bgcolor=003366 align=center>@values</td>\n";
         print "</tr>\n";
         push(@used_values,$value);
         push(@used_form_values,$form_value);
      }
   }
   print "</table><br><table width=500 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center><b>Username: <input type=text name=\"username\"></td><td align=center><b>Password: <input type=password name=\"password\"></td></tr></table>\n";
   print "<center><p>\n";
   print "<input type=submit value=\"Remove Messages\"> <input type=reset>\n";
   print "</form>\n";
   print "</body></html>\n";

}

###########################################################################
# Change Password                                                         #
#       By calling this section of the script, the admin can change his or#
#   her password.							  #
###########################################################################

elsif ($command eq 'change_passwd') {

   print "<html><head><title>AFF Message Board Administration</title>\n";
   print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style> \n";
   print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script>\n";
   print "</head>\n";
   print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center class=sec><i>Change Message Board Admin Password</i></td></tr>\n";
   print "<tr><td align=left><br>Fill out the form below completely to change your password and user name.\n";
   print "If new username is left blank, your old one will be assumed.<br><br></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "<tr><td align=center><a href=\"$cgi_url\?remove\" class=sec><b>REMOVE</b></a> | <a href=\"$cgi_url\?remove_by_date\" class=sec><b>REMOVE BY DATE</b></a> | <a href=\"$cgi_url\?remove_by_author\" class=sec><b>REMOVE BY AUTHOR</b></a> | <a href=\"$cgi_url\?remove_by_num\" class=sec><b>REMOVE BY MESSAGE NUMBER</b></a> | <a href=\"$cgi_url\" class=sec><b>ADMIN HOME</b></a> | <a href=\"javascript:boardWin('http://www.affund.org/cgi-bin/iboard/gp.cgi?p=10')\" class=sec><b>VIEW BOARD</b></a></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "</table>\n";
   print "<form method=POST action=\"$cgi_url\">\n";
   print "<input type=hidden name=\"action\" value=\"change_passwd\">\n";
   print "<center><table border=0 cellpadding=3 celllspacing=0>\n";
   print "<tr>\n";
   print "<td align=left><b>Username: </td><td><input type=text name=\"username\"><br></td>\n";
   print "</tr><tr>\n";
   print "<td align=left><b>Password: </td><td><input type=password name=\"password\"><br></td>\n";
   print "</tr><tr> </tr><tr>\n";
   print "<td align=left><b>New Username: </td><td><input type=text name=\"new_username\"><br></td>\n";
   print "</tr><tr>\n";
   print "<td align=left><b>New Password: </td><td><input type=password name=\"passwd_1\"><br></td>\n";
   print "</tr><tr>\n";
   print "<td align=left><b>Re-type New Password: </td><td><input type=password name=\"passwd_2\"><br></td>\n";
   print "</tr><tr>\n";
   print "<td align=center><br><input type=submit value=\"Change\"> </td><td align=center><br><input type=reset></td>\n";
   print "</tr></table></center>\n";
   print "</form></body></html>\n";

}

###########################################################################
# Remove Action                                                           #
#       This portion is used by the options remove and remove_by_num.     #
###########################################################################

elsif ($FORM{'action'} eq 'remove') {

   &check_passwd;

   for ($i = $FORM{'min'}; $i <= $FORM{'max'}; $i++) {
      if ($FORM{$i} eq 'all') {
         push(@ALL,$i);
      }
      elsif ($FORM{$i} eq 'single') {
         push(@SINGLE,$i);
      }
   }

   open(MSGS,"../../iboard/$mesgfile");
#   open(MSGS,"$basedir/$mesgfile");
   @lines = <MSGS>;
   close(MSGS);

   foreach $single (@SINGLE) {
      foreach ($j = 0;$j <= @lines;$j++) {
         if ($lines[$j] =~ /<!--top: $single-->/) {
            splice(@lines, $j, 3);
            $j -= 3;
         }
         elsif ($lines[$j] =~ /<!--end: $single-->/) {
            splice(@lines, $j, 1);
            $j--;
         }
      }
      $filename = "../../iboard/messages/$single\.$ext";
      print"../../iboard/$single\.$ext\n";
#      $filename = "$basedir/$mesgdir/$single\.$ext";
      if (-e $filename) {
         unlink("$filename") || push(@NOT_REMOVED,$single);
      }
      else {
         push(@NO_FILE,$single);
      }
      push(@ATTEMPTED,$single);
   }

   foreach $all (@ALL) {
      undef($top); undef($bottom);
      foreach ($j = 0;$j <= @lines;$j++) {
         if ($lines[$j] =~ /<!--top: $all-->/) {
            $top = $j;
         }
         elsif ($lines[$j] =~ /<!--end: $all-->/) {
            $bottom = $j;
         }
      }
      if ($top && $bottom) {
         $diff = ($bottom - $top);
         $diff++;
         for ($k = $top;$k <= $bottom;$k++) {
            if ($lines[$k] =~ /<!--top: (.*)-->/) {
               push(@DELETE,$1);
            }
         }
         splice(@lines, $top, $diff);
         foreach $delete (@DELETE) {
            $filename = "$basedir/$mesgdir/$delete\.$ext";
            if (-e $filename) {
               unlink($filename) || push(@NOT_REMOVED,$delete);
            }
            else {
               push(@NO_FILE,$delete);
            }
            push(@ATTEMPTED,$delete);
         }
      }
      else {
         push(@TOP_BOT,$all);
      }
   }

   open(IBOARD,">../../iboard/$mesgfile");
   print IBOARD @lines;
   close(IBOARD);      

   &return_html($FORM{'type'});

}

###########################################################################
# Remove Action by Date or Author                                         #
#       This portion is used by the method remove_by_date or 		  #
#   remove_by_author.     		  				  #
###########################################################################

elsif ($FORM{'action'} eq 'remove_by_date_or_author') {

   &check_passwd;

   @used_values = split(/\s/,$FORM{'used_values'});
   foreach $used_value (@used_values) {
      @misc_values = split(/\s/,$FORM{$used_value});
      foreach $misc_value (@misc_values) {
         push(@SINGLE,$misc_value);
      }
   }

   open(MSGS,"$basedir/$mesgfile");
   @lines = <MSGS>;
   close(MSGS);

   foreach $single (@SINGLE) {
      foreach ($j = 0;$j <= @lines;$j++) {
         if ($lines[$j] =~ /<!--top: $single-->/) {
            splice(@lines, $j, 3);
            $j -= 3;
         }
         elsif ($lines[$j] =~ /<!--end: $single-->/) {
            splice(@lines, $j, 1);
            $j--;
         }
      }
      $filename = "../../iboard/$mesgdir/$single\.$ext";
      if (-e $filename) {
         unlink("$filename") || push(@NOT_REMOVED,$single);
      }
      else {
         push(@NO_FILE,$single);
      }
      push(@ATTEMPTED,$single);
   }

   open(WWWBOARD,">../../iboard/$mesgfile");
   print WWWBOARD @lines;
   close(WWWBOARD);

   &return_html($FORM{'type'});

}

elsif ($FORM{'action'} eq 'change_passwd') {

#   print "$basedir/$passwd_file\n";
   open(PASSWD,"$passwd_file") || &error(passwd_file);
#   open(PASSWD,"$basedir/$passwd_file") || &error(passwd_file);
   $passwd_line = <PASSWD>;
   chop($passwd_line) if $passwd_line =~ /\n$/;
   close(PASSWD);

   ($username,$passwd) = split(/:/,$passwd_line);

   if (!($FORM{'passwd_1'} eq $FORM{'passwd_2'})) {
      &error(not_same);
   }

   $test_passwd = crypt($FORM{'password'}, substr($passwd, 0, 2));
   if ($test_passwd eq $passwd && $FORM{'username'} eq $username) {
      open(PASSWD,">$passwd_file") || &error(no_change);
      $new_password = crypt($FORM{'passwd_1'}, substr($passwd, 0, 2));
      if ($FORM{'new_username'}) {
         $new_username = $FORM{'new_username'};
      }
      else {
         $new_username = $username;
      }
      print PASSWD "$new_username:$new_password";
      close(PASSWD);
   }
   else {
      &error(bad_combo);
   }

   &return_html(change_passwd);
}

else {
   print "<html><head><title>AFF Message Board Administration</title>\n";
   print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style> \n";
   print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script>\n";
   print "</head>\n";
   print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
   print "<tr><td align=center class=sec><i>AFF Message Board Administration</i></td></tr>\n";
   print "<tr><td align=center><br>Choose your Method of modifying the AFF Message Board Below:<br><br></td></tr>\n";
   print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
   print "</table>\n";
   print "<table border=0><tr><td><br>\n";
   print "<ul>\n";
   print "<li><b>Remove Files</b>\n";
   print "<ul>\n";
   print "<li><a href=\"$cgi_url\?remove\">Remove Files</a>\n";
   print "<li><a href=\"$cgi_url\?removeby_num\">Remove Files by Message Number</a>\n";
   print "<li><a href=\"$cgi_url\?remove_by_date\">Remove Files by Date</a>\n";
   print "<li><a href=\"$cgi_url\?remove_by_author\">Remove Files by Author</a>\n";
   print "</ul><br>\n";
   print "<li><b>Password</b>\n";
   print "<ul>\n";
   print "<li><a href=\"$cgi_url\?change_passwd\">Change Admin Password / Username</a>\n";
   print "</ul>\n";
   print "</ul>\n";
}

#######################
# Parse Form Subroutine

sub parse_form {

   # Get the input
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

   # Split the name-value pairs
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      # Un-Webify plus signs and %-encoding
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

      $FORM{$name} = $value;
   }
}

sub return_html {
   $type = $_[0];
   if ($type eq 'remove') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Results of Message Board Removal</i></td></tr>\n";
   }
   elsif ($type eq 'remove_by_num') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Results of Message Board Removal</i></td></tr>\n";
   }
   elsif ($type eq 'remove_by_date') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Results of Message Board Removal</i></td></tr>\n";
   }
   elsif ($type eq 'remove_by_author') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Results of Message Board Removal</i></td></tr>\n";
   }
   elsif ($type eq 'change_passwd') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Admin Password Has Been Changed</i><br><br></td></tr>\n";
      print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
      print "<tr><td align=center><a href=\"$cgi_url\?remove\" class=sec><b>REMOVE</b></a> | <a href=\"$cgi_url\?remove_by_date\" class=sec><b>REMOVE BY DATE</b></a> | <a href=\"$cgi_url\?remove_by_author\" class=sec><b>REMOVE BY AUTHOR</b></a> | <a href=\"$cgi_url\?remove_by_num\" class=sec><b>REMOVE BY MESSAGE NUMBER</b></a> | <a href=\"$cgi_url\" class=sec><b>ADMIN HOME</b></a> | <a href=\"javascript:boardWin('http://www.affund.org/cgi-bin/iboard/gp.cgi?p=10')\" class=sec><b>VIEW BOARD</b></a></td></tr>\n";
      print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
      print "<tr><td align=center><br>Your Password for the AFF Message Board has been changed!  Results are below:\n";
      print "<br><br>New Username: $new_username\n";
      print "<br><br>New Password: $FORM{'passwd_1'}\n";
      print "<br><br><br><b>Do not forget these, since they are now encoded in a file, and not readable!.</b></td></tr>\n";
      print "</table></body></html>\n";
   }
   if ($type =~ /^remove/) {
      print "<tr><td align=left><br>Below is a short summary of what messages were removed from $mesgpage and the\n";
      print "$mesgdir directory.  All files that the script attempted to remove, were removed,\n";
      print "unless there is an error message stating otherwise.<br><br></td></tr>\n";
      print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
      print "<tr><td align=center><a href=\"$cgi_url\?remove\" class=sec><b>REMOVE</b></a> | <a href=\"$cgi_url\?remove_by_date\" class=sec><b>REMOVE BY DATE</b></a> | <a href=\"$cgi_url\?remove_by_author\" class=sec><b>REMOVE BY AUTHOR</b></a> | <a href=\"$cgi_url\?remove_by_num\" class=sec><b>REMOVE BY MESSAGE NUMBER</b></a> | <a href=\"$cgi_url\" class=sec><b>ADMIN HOME</b></a> | <a href=\"javascript:boardWin('http://www.affund.org/cgi-bin/iboard/gp.cgi?p=10')\" class=sec><b>VIEW BOARD</b></a></td></tr>\n";
      print "<tr><td bgcolor=0099FF><img src=\"http:www.affund.org/space.gif\" width=1 height=1></td></tr>\n";
      print "<tr><td align=left>\n";   	
 
      print "<table border=0><tr><td><br>\n";
      print "<b>Attempted to Remove:</b> @ATTEMPTED</td></tr>\n";
      if (@NOT_REMOVED) {
         print "<tr><td><br><b>Files That Could Not Be Deleted:</b> @NOT_REMOVED</td></tr>\n";
      }
      if (@NO_FILE) {
         print "<tr><td><br><b>Files Not Found:</b> @NO_FILE</td></tr>\n";
      }

##### MIKE TO ADD TEXT FOR SUCCESS ######
      print "<tr><td><br>Action was completed successfully</td></tr>\n";
      print "</table></td></tr></table>\n";
      print "</body></html>\n";
   }
}

sub error {
   $error = $_[0];
   if ($error eq 'bad_combo') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Bad Username - Password Combination</i></td></tr>\n";
      print "<tr><td align=center><br>You entered and invalid username password pair.  Please try again.</td></tr>\n";
      &passwd_trailer
   }
   elsif ($error eq 'passwd_file') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Could Not Open Password File For Reading</td></tr>\n";
      print "<tr><td align=center><br>Could not open the password file for reading!  Check permissions and try again.</td></tr>\n";
      &passwd_trailer
   }
   elsif ($error eq 'not_same') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Incorrect Password Type-In</td></tr>\n";
      print "<tr><td align=center><br>The passwords you typed in for your new password were not the same.\n";
      print "You may have mistyped, please try again.</td></tr>\n";
      &passwd_trailer
   }
   elsif ($error eq 'no_change') {
      print "<html><head><title>AFF Message Board Administration</title>\n";
      print "<style> td {font-family: arial; color: ffffff; font-size: 10pt; } td.sec {font-family: times; color: 0099FF; font-size: 16pt; } .nu {text-decoration: none;} a {color:ffffff; font-size:10pt; text-decoration:none} a:visited {color:ffffff;} a:hover {color:ff0000; text-decoration: none} a.sec {color:ffffff; font-size:8pt; text-decoration:none} a.sec:visited {color:ffffff;} a.sec:hover {color:ff0000; text-decoration: none} </style>\n";
      print "<script>function boardWin(URL) { boardWindow = window.open(URL,'board',\"width=650,height=450,scrollbars=yes\"); } </script></head>\n";
      print "<body bgcolor=003366><center><table width=650 cellpadding=0 cellspacing=0 border=0>\n";
      print "<tr><td align=center class=sec><i>Could Not Open Password File For Writing</td></tr>\n";
      print "<tr><td align=center><br>Could not open the password file for writing!  Password not changed!</td></tr>\n";
      &passwd_trailer
   }

   exit;
}

sub passwd_trailer {
   print "<tr><td align=center><br><br><a href=\"$cgi_url\" class=sec><b>ADMIN HOME</b></a></td></tr>\n";
   print "</table><br><br>\n";
   print "</body></html>\n";
}

sub check_passwd {
   open(PASSWD,"$passwd_file") || &error(passwd_file);
   $passwd_line = <PASSWD>;
   chop($passwd_line) if $passwd_line =~ /\n$/;
   close(PASSWD);

   ($username,$passwd) = split(/:/,$passwd_line);

   $test_passwd = crypt($FORM{'password'}, substr($passwd, 0, 2));
   if (!($test_passwd eq $passwd && $FORM{'username'} eq $username)) {
      &error(bad_combo);
   }
}
