;# Usage:
;#	%FORM = ();
;#	@names  = &getCGIVars(*FORM);
                  # Gets all form parameters, and stores them in %FORM.
                  # Returns an array containing %FORM's keys, in the order
                  # they were presented to the script.  
                  # If an illegal REQUEST_METHOD is presented, 
                  # returns an empty array....
;#     $success = &testSource(*FORM);
                  # Checks "source" parameter, if it exists, for "evil" input,
                  # and modifies the value of $CGI, if it passes the tests.
                  # Returns $TRUE if present and successful, or $FALSE if
                  # present but fails a test.  Also returns $TRUE if there
                  # is no "source" parameter....
;#      @errors = &requireCGIVars(*FORM, LIST);
                  # Tests form parameters in LIST, returns list of parameters
                  # which did not exist....
;#      @errors = &validateCGIVars(*FORM, $noUpDir, LIST);
                  # Tests form parameters in LIST, returns list of parameters
                  # which have "evil" characters.  If noUpDir is true, also
                  # tests LIST for parameters containing "../".  These are
                  # also added to the return value....
;#	...
;#	$foo = $FORM{varname};
;#     $success = &chkEmail($address);
                  # Checks the string parameter to ensure that it conforms
                  # to the pattern: <username>@<domain>.<TLD>.
                  # It will accept arbitrarily "deep" domain hierarchies,
                  # e.g., @foo.bar.baz.com, and doesn't care about leading
                  # or trailing whitespace, or a trailing period.
                  # Acceptable characters in <username> are: underscore,
                  # alphanumerics, period, dash, plus, and percent.
                  # Acceptable characters in <domain> and <TLD> are:
                  # underscore, alphanumerics, and dash.
;#                &fillTemplate(*FORM, *IN, *OUT, $removeTags, $deleteOld);
                  # Copies the input stream (IN) to the output stream (OUT),
                  # adding the values of various FORM variables to the output
                  # stream whenever a sequence of the form:
                  #      <!--#FORMVARNAME--> ... <!--/#FORMVARNAME-->
                  # is encountered.  FORMVARNAME is converted to lowercase
                  # and looked up in the FORM hash.  If a value for a
                  # particular FORMVARNAME is found in the FORM hash, it
                  # replaces whatever was between the two comments.
                  # If a value is not found, what was between the two comments
                  # will either be deleted or copied unchanged, depending
                  # upon the value of $deleteOld.
                  # If $removeTags is true, the HTML comments delimiting the
                  # replacement area in the template (<!--#FORMVARNAME-->)
                  # will also be removed from the output stream.
                  # Acceptable characters for FORMVARNAME are: 
                  # '-', A-Z, 0-9, '_', '+', '='
####
####  HTML Subroutines  ####
;#                &form_error;
                  # Prints a fairly generic HTML error page, indicating that
                  # the user's info was not processed.  If the FORM variables
                  # "header" or "footer" are present, the reference files
                  # (the values of these parameters) will be printed, instead
                  # of the default header and/or footer.  If "maintainer"
                  # is defined, there will be a mailto: link to that email
                  # address.  Otherwise, the mailto: link will be to
                  # "webmaster" (with no domain name specified).
;#                &html_header;
;#                &evil_characters;

package QCGI;

#----------   Common (Public) constants   -------------
$0 =~ m#/(\w+)$#;
$CGI = $1;
@WDAY = (Sun, Mon, Tue, Wed, Thu, Fri, Sat);
@MONTH = (Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec);
@TIME = localtime;
$PRTIME = sprintf("[%s, %s %2.2d, %2.2d %2.2d:%2.2d:%2.2d]",
                  $WDAY[$TIME[6]], $MONTH[$TIME[4]], $TIME[3], $TIME[5],
                  $TIME[2], $TIME[1], $TIME[0]);
$FALSE = 0;
$TRUE  = 1;
$CHARSALLOWED = 'a-zA-Z0-9_\.\,\-+ \t\/@%';

#----------   Public interface   -------------
sub main'getCGIVars
{
#print "in getVARS\n";
  local(*FORM) = @_;   # Associative array for storing form variables
  local(@names) = ();  # Return value - contains all keys in %FORM, in the
                       # order they were passed to the script.
                       # If there's an error, the null array is returned.
  local($buffer, @pairs, $name, $value, $usedbefore);

  # Get the input
  #print "POOP\n";
  if ($ENV{'REQUEST_METHOD'} eq 'POST')
  {
    $bytes = read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    #$bytes = read(STDIN, $buffer, 10);
    #print "LENGTH: [$ENV{'CONTENT_LENGTH'}]\n";
    #print "BUFFER: [$buffer]\n";
    #print "BYTES: [$bytes]\n";
  }  # if form method == POST
  elsif ($ENV{'REQUEST_METHOD'} eq 'GET')
  {
    $buffer = $ENV{'QUERY_STRING'};
  }  # if form method == GET
  else
  {
    return @names;
  }
  # Parse the input
  # Split the name-value pairs
  @pairs = split(/&/, $buffer);
    ##print "AFTER PAIRS\n";

  # Load the FORM variables
  for (@pairs)
  {
    #print CGI_LOG "INSIDE FOR\n";
    ($name1, $value1) = split(/=/, $_);
    $name1 =~ tr/+/ /;
    $name1 =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value1 =~ tr/+/ /;
    $value1 =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    # Is this key used more than once?
    $usedbefore = defined($FORM{$name1});
    # If this key is used more than once, concatenate the values....
    $FORM{$name1} .= ($usedbefore) ? ", $value1" : $value1;
    push(@names, $name1)  if !$usedbefore;
  }
  
  return @names;
}  # getCGIVars


sub main'testSource
{
  local(*FORM) = @_;

  # Check the "source" parameter, if it exists, for dangerous input.
  if (defined($FORM{source})
      && (($FORM{source} !~ /^[$CHARSALLOWED]+$/)
          || ($FORM{source} =~ m#\.\./#)))
  {
    return $FALSE;
  } elsif (defined($FORM{source}) && ($FORM{source} ne ''))
  {
    # Alter $CGI, if source parameter is provided, and is "good"
    $CGI = $FORM{source};
  }
  return $TRUE;
}  # testSource


sub main'requireCGIVars
{
  local(*FORM, @required) = @_;
  local(@errors) = ();

  ####  Validate the "control" parameters...  ####
  # Check all required parameters, to ensure they exist.
  foreach (@required)
  {
    push(@errors, $_)  if !defined($FORM{$_}) || ($FORM{$_} eq '');
  }
  return @errors;
}  # requireCGIVars


sub main'validateCGIVars
{
  local(*FORM, $noUpDir, @varnames) = @_;
  local(@errors) = ();

  ####  Validate "dangerous" input for evil characters  ####
  # If $noUpDir is $TRUE, also ensure that there is no "../" in the string!
  # (This would be done for file and directory names, for example.)
  foreach (@varnames)
  {
    push(@errors, $_)  if defined($FORM{$_})
                          && (($FORM{$_} !~ /^[$CHARSALLOWED]+$/)
                              || ($noUpDir && ($FORM{$_} =~ m#\.\./#)));
  }
  return @errors;
}  # validateCGIVars


sub main'chkEmail
{
  local($addr) = @_;

  return $FALSE  if (!$addr);
  return $TRUE
    if $addr =~ /^\s*[\w\.\-+%]+@[\w\-]+\.[\w\-]+(\.[\w\-]+)*\.*\s*$/;
  return $FALSE;
}  # &chkemail


sub main'fillTemplate
{
  local(*FORM, *IN, *OUT, $removeTags, $deleteOld) = @_;
  local($tagchars) = ('-A-Z0-9_+=');

  # Slurp the entire file...
  @_ = <IN>;
  $_ = join('', @_);

  # Do the substitution!!
  while (/<!--\#([$tagchars]+)-->(.*?)<!--\/\#\1-->/s)  ### Must NOT be greedy!
  {
    $tag = $1;
    # $savevalue is only used if $deleteOld has NOT been requested.
    $savevalue =  ($deleteOld) ? "" : $2;
    $varname = $tag;
    $varname =~ tr/A-Z/a-z/;
    $tagOpen = ($removeTags) ? "" : "<!--\##$tag-->";
    $tagClose = ($removeTags) ? "" : "<!--\/\#$tag-->";

    if (defined($FORM{$varname}))
    {
      # Replace or enter value.  Also, modify tag to prevent re-match.
      # We'll fix this later....
      # NOTE: Must prevent interpretation of $& value as regexp special chars!
      s/\Q$&\E/$tagOpen$FORM{$varname}$tagClose/s;
    } else
    {
      # We have no replacement value, so prevent re-match -- we'll fix later.
      # NOTE: Must prevent interpretation of $& value as regexp special chars!
      s/\Q$&\E/$tagOpen$savevalue$tagClose/s;
    }
  }  # while there are more tags to replace

  # Fix what we did before -- I hope they didn't *want* '##' together!
  s/<!--\##/<!--\#/sg;

  print OUT;

}  # &fillTemplate


################################################################
###############     HTML Subroutines (++)     ##################
################################################################
sub main'form_error
{
  local($maintainer, $subject) = @_;

  $maintainer = $ENV{SERVER_ADMIN}  if !&main'chkEmail($maintainer);

  # Format an error message for the user
      print "Content-Type: text/html\n\n";
      require "html_print_header.pl";
      require "html_print_form_error.pl";
      require "html_print_footer.pl";
  #$FORM{header} ?
#    (print("Content-Type: text/html\n\n"),
#     &prfile("$ENV{DOCUMENT_ROOT}$FORM{dir}$FORM{header}"))
#  :
#    &main'html_header("$subject Form Error");
#  print "Your information was not processed.  Please send mail to\n";
#  print "<a href=\"mailto:$maintainer\">$maintainer</a>,\n";
#  print "describing what you did, and what happened.\n";
#  $FORM{footer} ?
#    &prfile("$ENV{DOCUMENT_ROOT}$FORM{dir}$FORM{footer}")
#  :
#    print("</body>\n</html>\n");
}  # &form_error

sub main'html_header
{
  local($doc_title) = @_;

  print "Content-Type: text/html\n\n";
  print "<html>\n";
  print "<head>\n";
  print "<title>$doc_title</title>\n";
  print "</head>\n";
  print "<body bgcolor=#FFFFFF text=#000000>\n";
  print "<center><h2>$doc_title</h2></center>\n";
  print "<hr>\n";
  print "<p>\n";
}  # &html_header

sub main'evil_characters
{
  local($INFO) = @_;

  $FORM{header} ?
    (print("Content-Type: text/html\n\n"),
     &prfile("$ENV{DOCUMENT_ROOT}$FORM{dir}$FORM{header}"))
  :
    &main'html_header("Invalid Information");
  print "The $INFO you submitted contains illegal \n";
  print "characters.  Please back up and correct this, then resubmit.\n";
  $FORM{footer} ?
    &prfile("$ENV{DOCUMENT_ROOT}$FORM{dir}$FORM{footer}")
  :
    print("</body>\n</html>\n");
}  # &evil_characters


#----------   "Semi-public" Subroutines (in package QCGI)   -------------
sub prfile
{
  local($file) = @_;

  open(FD, $file) || return $FALSE;
  while (<FD>)
  {
    print $_;
  }
  return $TRUE;
}  # &prfile

1;
