#!/usr/bin/perl 
# Define Variables

require "config.txt";

# Get the Data Number
&get_number;

# Get Form Information
&parse_form;

print "Content-type: text/html\n\n";

# Put items into nice variables
&get_variables;

# Open the new file and write information to it.
&new_file;

# Open the Main iBoard File to add link
&main_page;

# Now Add Thread to Individual Pages
#if ($num_followups >= 1) {
   &thread_pages;
#}

# Return the user HTML
&return_html;

# Increment Number
&increment_num;

############################
# Get Data Number Subroutine

sub get_number {
   open(NUMBER,"$basedir/$datafile");
   $num = <NUMBER>;
   close(NUMBER);
   if ($num == 99999)  {
      $num = "1";
   }
   else {
      $num++;
   }
}

#######################
# Parse Form Subroutine

sub parse_form {

   # Get the input
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

   # Split the name-value pairs
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      # Un-Webify plus signs and %-encoding
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;

      if ($allow_html != 1) {
         $value =~ s/<([^>]|\n)*>//g;
      }
      else {
         unless ($name eq 'body') {
	    $value =~ s/<([^>]|\n)*>//g;
         }
      }

      $FORM{$name} = $value;

      open (COLORFUL,"colorful.txt") || die $!;
      while (<COLORFUL>)
      {
           $c_line = $_;

           chop($c_line);
           $c_line =~ tr/[A-Z]/[a-z]/; 
#print STDOUT "Content-Type: text/html\n\n";
#print STDOUT "LINE: [$c_line]";
#die;
           
           @c_word = split (/ /,$FORM{$name}); 

           for($index=0; $c_word[$index]; $index++)
           {
              $c_word[$index] =~ tr/[A-Z]/[a-z]/; 

              if ($c_word[$index] eq $c_line && $c_line ne "")
              {
                 print STDOUT "Content-Type: text/html\n";
#print STDOUT "W1: [$c_word[0]]  W2: [$c_word[1]]";
                 print STDOUT "Location: /iboard/colorful_error.htm\n\n";

                 close(COLORFUL);
                 exit;
              }
           }
      }
      close(COLORFUL);

   }

}


###############
# Get Variables

sub get_variables {

   if ($FORM{'followup'}) {
      $followup = "1";
      @followup_num = split(/,/,$FORM{'followup'});
      $num_followups = @followups = @followup_num;
      $last_message = pop(@followups);
      $origdate = "$FORM{'origdate'}";
      $origname = "$FORM{'origname'}";
      $origsubject = "$FORM{'origsubject'}";
   }
   else {
      $followup = "0";
   }

   if ($FORM{'name'}) {
      $name = "$FORM{'name'}";
      $name =~ s/"//g;
      $name =~ s/<//g;
      $name =~ s/>//g;
      $name =~ s/\&//g;
   }

   if ($FORM{'email'} =~ /.*\@.*\..*/) {
      $email = "$FORM{'email'}";
   }

   if ($FORM{'subject'}) {
      $subject = "$FORM{'subject'}";
      $subject =~ s/\&/\&amp\;/g;
      $subject =~ s/"/\&quot\;/g;
   }

   if ($FORM{'url'} =~ /.*\:.*\..*/ && $FORM{'url_title'}) {
      $message_url = "$FORM{'url'}";
      $message_url_title = "$FORM{'url_title'}";
   }

   if ($FORM{'img'} =~ /.*tp:\/\/.*\..*/) {
      $message_img = "$FORM{'img'}";
   }

   if ($FORM{'body'}) {
      $body = "$FORM{'body'}";
      $body =~ s/\cM//g;
      $body =~ s/\n\n/<p>/g;
      $body =~ s/\n/<br>/g;

      $body =~ s/&lt;/</g; 
      $body =~ s/&gt;/>/g; 
      $body =~ s/&quot;/"/g;
   }

   if ($quote_text == 1) {
      $hidden_body = "$body";
      $hidden_body =~ s/</&lt;/g;
      $hidden_body =~ s/>/&gt;/g;
      $hidden_body =~ s/"/&quot;/g;
   }

   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

   if ($sec < 10) {
      $sec = "0$sec";
   }
   if ($min < 10) {
      $min = "0$min";
   }
   if ($hour < 10) {
      $hour = "0$hour";
   }
   if ($mon < 10) {
      $mon = "0$mon";
   }
   if ($mday < 10) {
      $mday = "0$mday";
   }

   $month = ($mon + 1);

   @months = ("January","February","March","April","May","June","July","August","September","October","November","December");

   $year += 1900;

   if ($use_time == 1) {
      $date = "$hour\:$min\:$sec $month/$mday/$year";
   }
   else {
      $date = "$month/$mday/$year";
   }
   chop($date) if ($date =~ /\n$/);

   $long_date = "$months[$mon] $mday, $year at $hour\:$min\:$sec";
}      

#####################
# New File Subroutine

sub new_file 
{

   open(NEWFILE,">$basedir/$mesgdir/$num\.$ext") || die $!;
   open(FOLLOWUPFILE,">$basedir/$mesgdir/followup-$num\.$ext") || die $!;
   require "html_print_new_message_file.pl";
   require "html_print_new_followup_file.pl";

}

###############################
# Main iBoard Page Subroutine

sub main_page 
{
   open(MAIN,"$basedir/$mesgfile") || die $!;
   @main = <MAIN>;
   close(MAIN);

   open(MAIN,">$basedir/$mesgfile") || die $!;
   require "html_print_main_page.pl";
}

############################################
# Add Followup Threading to Individual Pages
sub thread_pages 
{

   foreach $followup_num (@followup_num) 
   {
      open(FOLLOWUP,"$basedir\/$mesgdir\/$followup_num\.$ext") || die ;
      @followup_lines = <FOLLOWUP>;
      close(FOLLOWUP);

      open(WFOLLOWUP,">$basedir\/$mesgdir\/$followup_num\.$ext")  || die ;
      foreach $followup_line (@followup_lines) 
      {
         $work = 0;
####################################
if ($followup_line =~ /<ul><!--insert: $last_message-->/)
{
#print "FIRST";
    print WFOLLOWUP "<tr><td colspan=2><br>\n";
    print WFOLLOWUP "<ul><!--insert: $last_message-->\n";
    print WFOLLOWUP "<!--top: $num--><li><a href=\"$num\.$ext\">$subject</a> <b>$name</b> <i>$date</i>\n";
    print WFOLLOWUP "(<!--responses: $num-->0)\n";
    print WFOLLOWUP "<ul><!--insert: $num-->\n";
    print WFOLLOWUP "</ul><!--end: $num-->\n";
}
elsif ($followup_line =~ /\(<!--responses: (.*)-->(.*)\)/)
{
#print "SECOND";
    $response_num = $1;
    $num_responses = $2;
    $num_responses++;
    foreach $followup_num (@followup_num)
    {
       if ($followup_num == $response_num)
       {
          print WFOLLOWUP "(<!--responses: $followup_num-->$num_responses)\n";
          $work = 1;
       }
    }
    if ($work != 1)
    {
       print WFOLLOWUP "$followup_line";
    }
}
else
{
    print WFOLLOWUP "$followup_line";
}
##################################
      }
      close(WFOLLOWUP);
   }
}

sub return_html 
{
   require "html_print_add_confirm.pl";
}

sub increment_num 
{
   open(NUM,">$basedir\/$datafile") || die $!;
   print NUM "$num";
   close(NUM);
}

sub error 
{
   $error = $_[0];

   require "html_print_error.pl";

   exit;
}

sub rest_of_form {

   print "<form method=POST action=\"$cgi_url\">\n";

   require "html_print_post_form.pl";

}
